use Prima;
use Prima::Classes;
use Prima::Calendar;
use Prima::Label;
use Prima::Lists;
use Prima::Notebooks;


package FahrplanWindow;
use vars qw(@ISA);
@ISA = qw(Prima::Window);

sub profile_default
{
   my $def = $_[ 0]-> SUPER::profile_default;
   my %prf = (
       centered => 1,
       windowState => ws::Normal,
       sizeMax => [ 1024, 768],
       height => 659,
       width => 659,
       text => 'Fahrplanverwaltung',
       autoEnableChildren => 0,
       origin => [ 460, 334],
       borderIcons => bi::SystemMenu | bi::Minimize | bi::Maximize | bi::TitleBar,
       originDontCare => 0,
       bottom => 334,
       size => [ 659, 659],
       left => 460,
       sizeDontCare => 0,
       name => 'Fahrplan',
       sizeMin => [ 100, 100],
       growMode => gm::DontCare,
       icon => undef,
       designScale => [ 5, 13],
   );
   @$def{keys %prf} = values %prf;
   return $def;
}

sub onChild_TabbedNotebook1 {
   $_[2]-> defaultInsertPage( $_[1]-> {extras}-> {$_[3]})
}

sub onChildCreate_TabbedNotebook1 {
   $_[3]-> origin( $_[3]->left-$_[3]->owner->left, $_[3]-> bottom-$_[3]->owner->bottom);
}

sub init
{
   my $self = shift;
   my %instances = map {$_ => {}} qw(TabbedNotebook1);
   $instances{TabbedNotebook1}->{extras} = {
      Label2 => '0',
      Notebook1 => '0',
      Generierte_Fahrplaene => '0',
      Label4 => '0',
      Neue_CSV_Dateien => '0',
      Kalender => '0',
   };
   my %profile = $self-> SUPER::init(@_);
   my %names   = ( q(Fahrplan) => $self);
   $self-> lock;
   $names{EEX_Fahrplanverwaltung} = $names{Fahrplan}-> insert( qq(Prima::Label) => 
       centered => 0,
       font => {name => 'Arial', size => 20, style => 0, pitch => fp::Default},
       color => 0xff0000,
       valignment => ta::Middle,
       size => [ 360, 41],
       name => 'EEX_Fahrplanverwaltung',
       text => 'This label won\'t be displayed',
       transparent => 1,
       showHint => 0,
       dark3DColor => 0x840000,
       light3DColor => 0xff0000,
       origin => [ 132, 608],
       y_centered => 0,
       growMode => gm::GrowHiX | gm::GrowHiY,
   );
   $names{TabbedNotebook1} = $names{Fahrplan}-> insert( qq(Prima::TabbedNotebook) => 
       tabs => ['Start ', 'Config', ],
       size => [ 652, 600],
       text => '',
       name => 'TabbedNotebook1',
       pageIndex => 0,
       origin => [ 4, 4],
       growMode => gm::GrowHiX | gm::GrowHiY,
       tabOrder => 1,
   );
   onChild_TabbedNotebook1(q(TabbedNotebook1), $instances{TabbedNotebook1}, $names{TabbedNotebook1}, q(Neue_CSV_Dateien));
   $names{Neue_CSV_Dateien} = $names{TabbedNotebook1}-> insert( qq(Prima::ListBox) => 
       size => [ 292, 252],
       text => '',
       name => 'Neue_CSV_Dateien',
       origin => [ 32, 224],
       multiSelect => 1,
       growMode => gm::DontCare,
       onPostMessage => sub { },
       items => [],
   );
   onChildCreate_TabbedNotebook1(q(TabbedNotebook1), $instances{TabbedNotebook1}, $names{TabbedNotebook1}, $names{Neue_CSV_Dateien});
   onChild_TabbedNotebook1(q(TabbedNotebook1), $instances{TabbedNotebook1}, $names{TabbedNotebook1}, q(Label2));
   $names{Label2} = $names{TabbedNotebook1}-> insert( qq(Prima::Label) => 
       centered => 0,
       font => {name => 'Arial', size => 12, style => 0, pitch => fp::Default},
       enabled => 1,
       helpContext => 'Die aufgefhrten CSV-Dateien wurden noch nicht verarbeitet!',
       hint => 'Die aufgefhrten CSV-Dateien wurden noch nicht verarbeitet!',
       size => [ 208, 25],
       name => 'Label2',
       text => 'This label won\'t be displayed',
       origin => [ 32, 480],
       growMode => gm::GrowHiX | gm::GrowHiY,
   );
   onChildCreate_TabbedNotebook1(q(TabbedNotebook1), $instances{TabbedNotebook1}, $names{TabbedNotebook1}, $names{Label2});
   onChild_TabbedNotebook1(q(TabbedNotebook1), $instances{TabbedNotebook1}, $names{TabbedNotebook1}, q(Generierte_Fahrplaene));
   $names{Generierte_Fahrplaene} = $names{TabbedNotebook1}-> insert( qq(Prima::ListBox) => 
       size => [ 281, 430],
       name => 'Generierte_Fahrplaene',
       origin => [ 340, 46],
       multiSelect => 0,
       growMode => gm::DontCare,
       onPostMessage => sub { },
       items => [],
   );
   onChildCreate_TabbedNotebook1(q(TabbedNotebook1), $instances{TabbedNotebook1}, $names{TabbedNotebook1}, $names{Generierte_Fahrplaene});
   onChild_TabbedNotebook1(q(TabbedNotebook1), $instances{TabbedNotebook1}, $names{TabbedNotebook1}, q(Kalender));
   $names{Kalender} = $names{TabbedNotebook1}-> insert( qq(Prima::Calendar) => 
       font => {name => 'Courier', size => 8, style => fs::Bold, pitch => fp::Fixed},
       useLocale => 0,
       onChange => sub { my $self = $_[0];
                                                               
$self->owner->Version->notify("PostMessage", 0, 0);
$self->owner->Neue_CSV_Dateien->notify("PostMessage", 0, 0);
$self->owner->Generierte_Fahrplaene->notify("PostMessage", 0, 0);
  
},
       firstDayOfWeek => '1',
       hint => 'Whlen Sie das Lieferdatum fr die Fahrplangenerierung aus.',
       size => [ 284, 175],
       name => 'Kalender',
       origin => [ 36, 32],
       growMode => gm::GrowHiX | gm::GrowHiY,
   );
   onChildCreate_TabbedNotebook1(q(TabbedNotebook1), $instances{TabbedNotebook1}, $names{TabbedNotebook1}, $names{Kalender});
   onChild_TabbedNotebook1(q(TabbedNotebook1), $instances{TabbedNotebook1}, $names{TabbedNotebook1}, q(Label4));
   $names{Label4} = $names{TabbedNotebook1}-> insert( qq(Prima::Label) => 
       size => [ 179, 20],
       font => {name => 'MS Shell Dlg', size => 8, style => 0, pitch => fp::Default},
       text => 'This label will be displayed',
       name => 'Label4',
       origin => [ 340, 480],
       growMode => gm::GrowHiX | gm::GrowHiY,
   );
   onChildCreate_TabbedNotebook1(q(TabbedNotebook1), $instances{TabbedNotebook1}, $names{TabbedNotebook1}, $names{Label4});
   $self-> unlock;
   return %profile;
}

sub on_destroy
{
   $::application-> close;
}

package FahrplanAuto;

use Prima::Application;
FahrplanWindow-> create;
run Prima;

